﻿<%@ Page Language="c#" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ import Namespace="System.Collections.Generic" %>

<script runat="server">

    static string empty = "<b>BRAK</b>";
	 
    class Pozycja {
        string blok;
        public string Blok {
            get { return blok; }
            set { blok = value; }
        }
        string pole;
        public string Pole {
            get { return pole; }
            set { pole = value; }
        }
        string numer;
        public string Numer {
            get { return numer; }
            set { numer = value; }
        }
        string wartosc;
        public string Wartosc {
            get { return wartosc; }
            set { wartosc = value; }
        }
        string tytul;
        public string Tytul {
            get { return tytul; }
            set { tytul = value; }
        }                
        string opis;
        public string Opis {
            get { return opis; }
            set { opis = value; }
        }
        bool wymagane;
        public bool Wymagane {
            get { return wymagane; }
            set { wymagane = value; }
        }
        public Pozycja(string blok, string tytul, string pole, string numer, string opis, bool wymagane) {
            this.blok = blok;
            this.tytul = tytul;
            this.pole = pole;
            this.numer = numer;
            this.opis = opis;
            this.wymagane = wymagane;
        }
        public bool Porownaj(string blok, string pole) {
            return (this.blok == blok && this.pole == pole);
        }
        public void Przypisz(string wartosc) {
            if (wymagane)
                this.wartosc = (wartosc.Length != 0) ? wartosc : empty;
            else
                this.wartosc = wartosc;
        }
    }

    public class Params : ContextBase {
        public Params(Context context) : base(context) {
        }

        bool braki;
        [Caption("Pokaż tylko braki")]
        public bool Braki {
            get { return braki; }
            set {
                braki = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    Params pars;
    [Context]
    public Params Pars {
        set { pars = value; }
    }
    
    void OnContextLoad(Object sender, EventArgs e) {
        Soneta.Deklaracje.ZUS.ZIUA ziua = (Soneta.Deklaracje.ZUS.ZIUA)dc[typeof(Soneta.Deklaracje.ZUS.ZIUA)];
        if (ziua == null)
            throw new Exception("Wydruk przeznaczony tylko dla deklaracji ZIUA");
       
        List<Pozycja> pozycje = new List<Pozycja>();
        pozycje.Add(new Pozycja("III", "Poprzednie dane identyfikacyjne osoby ubezpieczonej", "p1", "1", "Numer PESEL", true));
        pozycje.Add(new Pozycja("III", "Poprzednie dane identyfikacyjne osoby ubezpieczonej", "p2", "2", "Numer NIP", false));
        pozycje.Add(new Pozycja("III", "Poprzednie dane identyfikacyjne osoby ubezpieczonej", "p3", "3", "Rodzaj dokumentu", false));
        pozycje.Add(new Pozycja("III", "Poprzednie dane identyfikacyjne osoby ubezpieczonej", "p4", "4", "Seria i nr dokumentu", true));
        pozycje.Add(new Pozycja("III", "Poprzednie dane identyfikacyjne osoby ubezpieczonej", "p5", "5", "Nazwisko", true));
        pozycje.Add(new Pozycja("III", "Poprzednie dane identyfikacyjne osoby ubezpieczonej", "p6", "6", "Imię pierwsze", true));
        pozycje.Add(new Pozycja("III", "Poprzednie dane identyfikacyjne osoby ubezpieczonej", "p7", "7", "Data urodzenia", true));
        pozycje.Add(new Pozycja("IV", "Aktualne dane identyfikacyjne osoby ubezpieczonej", "p1", "1", "Numer PESEL", true));
        pozycje.Add(new Pozycja("IV", "Aktualne dane identyfikacyjne osoby ubezpieczonej", "p2", "2", "Numer NIP", false));
        pozycje.Add(new Pozycja("IV", "Aktualne dane identyfikacyjne osoby ubezpieczonej", "p3", "3", "Rodzaj dokumentu", false));
        pozycje.Add(new Pozycja("IV", "Aktualne dane identyfikacyjne osoby ubezpieczonej", "p4", "4", "Seria i nr dokumentu", true));
        pozycje.Add(new Pozycja("IV", "Aktualne dane identyfikacyjne osoby ubezpieczonej", "p5", "5", "Nazwisko", true));
        pozycje.Add(new Pozycja("IV", "Aktualne dane identyfikacyjne osoby ubezpieczonej", "p6", "6", "Imię pierwsze", true));
        pozycje.Add(new Pozycja("IV", "Aktualne dane identyfikacyjne osoby ubezpieczonej", "p7", "7", "Data urodzenia", true));
                                
        string wartosc = "";
        string p31 = "", p34 = "";
        string p41 = "", p44 = "";
        foreach (Soneta.Deklaracje.DefinicjaBloku defBlok in ziua.Bloki)
            foreach (Soneta.Deklaracje.DefinicjaPola defPole in defBlok.Pola)
                foreach (Pozycja pz in pozycje)
                    if (pz.Porownaj(defBlok.XmlTag, defPole.XmlTag)) {
                        wartosc = defPole.GetValue(ziua).ToString();
                        switch (defPole.Typ) {
                            case TypPolaDeklaracji.Bool:
                            case TypPolaDeklaracji.Int:
                                if (wartosc.ToLower() == "true")
                                    wartosc = "TAK";
                                else if (wartosc.ToLower() == "false")
                                    wartosc = "NIE";
                                break;
                        }
                        if (pz.Numer == "3" && wartosc == "0")
                            wartosc = "";
                        pz.Przypisz(wartosc);
                        if (pz.Blok == "III" && pz.Numer == "1")
                            p31 = wartosc;
                        else if (pz.Blok == "III" && pz.Numer == "4")
                            p34 = wartosc;
                        if (pz.Blok == "IV" && pz.Numer == "1")
                            p41 = wartosc;
                        else if (pz.Blok == "IV" && pz.Numer == "4")
                            p44 = wartosc;
                        break;
                    }

        if (p31.Length > 0 || p34.Length > 0)
            foreach (Pozycja pz in pozycje)
                if (pz.Blok == "III" && (pz.Numer == "1" || pz.Numer == "4") && pz.Wartosc == empty)
                    pz.Wartosc = "";
        if (p41.Length > 0 || p44.Length > 0)
            foreach (Pozycja pz in pozycje)
                if (pz.Blok == "IV" && (pz.Numer == "1" || pz.Numer == "4") && pz.Wartosc == empty)
                    pz.Wartosc = "";
        
        Grid1.DataSource = pozycje;
    }

    void Grid1_BeforeRow(Object sender, RowEventArgs args) {
        Pozycja pz = (Pozycja)args.Row;
        if (pars.Braki)
            args.VisibleRow = pz.Wartosc == empty;
    }    
    
</script>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Deklaracja ZIUA</title> 
    <meta content="False" name="vs_showGrid" />
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR" />
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
	</head>
	<BODY>
        <FORM id="DeklaracjaZIUA" method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="OnContextLoad"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" runat="server" title="Deklaracja ZIUA"></eb:ReportHeader>
			<ea:Grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" GroupLine="{0}. {1}" GroupData0="Blok" GroupData1="Tytul">
				<Columns>
					<ea:GridColumn runat="server" Align="Left" Caption="Pole" DataMember="Numer" Width="6"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="Nazwa" DataMember="Opis"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="Wartość" DataMember="Wartosc" Width="30"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</html>
